// DOSingleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DOSingle.h"
#include "DOSingleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDOSingleDlg dialog

CDOSingleDlg::CDOSingleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDOSingleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDOSingleDlg)
	m_DOValue_CH3 = 0;
	m_bit0 = FALSE;
	m_bit1 = FALSE;
	m_bit2 = FALSE;
	m_bit3 = FALSE;
	m_bit4 = FALSE;
	m_bit5 = FALSE;
	m_bit6 = FALSE;
	m_bit7 = FALSE;
//	m_channel = _T("");
	m_deviceNumber = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDOSingleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDOSingleDlg)
	DDX_Control(pDX, IDC_INIT, m_init);
	DDX_Control(pDX, IDC_WRITE_CH3, m_writeCH3);
	DDX_Control(pDX, IDC_WRITEDO, m_writedoButton);
	DDX_Text(pDX, IDC_DO_CH3, m_DOValue_CH3);
	DDV_MinMaxUInt(pDX, m_DOValue_CH3, 0, 255);
	DDX_Check(pDX, IDC_CHECK1, m_bit0);
	DDX_Check(pDX, IDC_CHECK2, m_bit1);
	DDX_Check(pDX, IDC_CHECK3, m_bit2);
	DDX_Check(pDX, IDC_CHECK4, m_bit3);
	DDX_Check(pDX, IDC_CHECK5, m_bit4);
	DDX_Check(pDX, IDC_CHECK6, m_bit5);
	DDX_Check(pDX, IDC_CHECK7, m_bit6);
	DDX_Check(pDX, IDC_CHECK8, m_bit7);
	DDX_Text(pDX, IDC_DEVICE, m_deviceNumber);
	DDV_MinMaxUInt(pDX, m_deviceNumber, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDOSingleDlg, CDialog)
	//{{AFX_MSG_MAP(CDOSingleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_INIT, OnInit)
	ON_BN_CLICKED(IDC_WRITEDO, OnWriteDO)
//	ON_BN_CLICKED(IDC_CONFIG, OnConfig)
	ON_BN_CLICKED(IDC_WRITE_CH3, OnWriteCh3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDOSingleDlg message handlers

BOOL CDOSingleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	// set our pointers equal to something safe
	m_pSR=NULL;
    m_driverInstance=NULL;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDOSingleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDOSingleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDOSingleDlg::OnClose() 
{
// When the Dialog is closed (WM_CLOSE) close down DriverLINX
// code to clean up after DriverLINX
if (m_driverInstance != NULL)
{
   CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
   m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
}
if (m_pSR != NULL)
{

   delete(m_pSR); //de-allocate the memory used by the service request
   m_pSR=NULL;
}	
	
	CDialog::OnClose();  // pass the message on up the class structure
}

void CDOSingleDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CDOSingleDlg::OnInit() 
{
		// Open the driver and Initialize the hardware

UpdateData(TRUE);
// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kpciiso"); //Open DriverLINX driver
// return focus to our application
CWnd::SetActiveWindow();
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=m_deviceNumber; //set the device number to the device being used
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application

if (DriverLINX(m_pSR) == NoErr)  // execute the task
{  // success
m_writeCH3.EnableWindow(TRUE);  // enable the Write Ch 3 button
m_writedoButton.EnableWindow(TRUE);  // enable the Write DO button
m_init.EnableWindow(FALSE);  // disable the Init button
}
else  // problem has occured
{  showMessage(m_pSR);}  // display the error message box
	
}

void CDOSingleDlg::OnWriteDO() 
{
	// bring in the data from the text box on the dialog
    UpdateData(TRUE); // update from the Dialog
	m_pSR->status.u.ioValue = 1 * m_bit0 + 2*m_bit1 + 4*m_bit2;
    m_pSR->status.u.ioValue = m_pSR->status.u.ioValue + 8*m_bit3 + 16*m_bit4 + 32*m_bit5 + 64*m_bit6 + 128*m_bit7;

// setup a single channel, polled mode DO task

	m_pSR->mode = POLLED;  // foreground operation
	m_pSR->operation = START; 
	m_pSR->subsystem = DO;  // use DO subsystem of board
	m_pSR->start.typeEvent = COMMAND;  // start when DriverLINX function is called
	m_pSR->stop.typeEvent = TCEVENT;   // stop automatically
	m_pSR->timing.typeEvent = NULLEVENT;  // if POLLED no timing required
	m_pSR->channels.nChannels = 1;        // only the start channel specified
	m_pSR->channels.chanGain[0].channel = 2; // use chan 2
	// KPCI-PIO32IOA has two DO channels:  channels 2 and 3
	m_pSR->channels.numberFormat = tNATIVE;
	if (DriverLINX(m_pSR) != NoErr)  // execute the task
	{  // problem has occured
     showMessage(m_pSR);  // display the error message box
	}
	
}


void CDOSingleDlg::OnWriteCh3() 
{
	// bring in the data from the text box on the dialog
    UpdateData(TRUE); // update from the Dialog
	m_pSR->status.u.ioValue = m_DOValue_CH3;  // a value between 0 and 255

	/*
      The status.u.ioValue member of the SR structure can host single value
	  inputs or outputs.  No need to allocate and use a Buffer for single
	  value reads/writes.
  */
// setup a single channel, polled mode DO task
	
	m_pSR->hWnd = m_hWnd;
	m_pSR->mode = POLLED;  // foreground operation
	m_pSR->operation = START; 
	m_pSR->subsystem = DO;  // use DO subsystem of board
	m_pSR->start.typeEvent = COMMAND;  // start when DriverLINX function is called
	m_pSR->stop.typeEvent = TCEVENT;   // stop automatically
	m_pSR->timing.typeEvent = NULLEVENT;  // if POLLED no timing required
	m_pSR->channels.nChannels = 1;        // only the start channel specified
	m_pSR->channels.chanGain[0].channel = 3; // use chan 3
	m_pSR->channels.numberFormat = tNATIVE;
	if (DriverLINX(m_pSR) != NoErr)  // execute the task
	{  // problem has occured
     showMessage(m_pSR);  // display the error message box
	}
	
}
